/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/


// DatagramSocket.h: interface for the CDatagramSocket class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DATAGRAMSOCKET_H__F8E9E0F8_F92E_11D2_BAFE_0080C773B9A1__INCLUDED_)
#define AFX_DATAGRAMSOCKET_H__F8E9E0F8_F92E_11D2_BAFE_0080C773B9A1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMainFrame;

class CDatagramSocket  
{
public:
	void SetPeerAddr(char* ip, int port);
	SOCKET m_socket;
	void OnReceive();
	BOOL Create(int port = 0);
	CDatagramSocket(CMainFrame* pMFrame);
	virtual ~CDatagramSocket();
	void Send(char* buffer, int length);
	int GetPort();

private:
	struct sockaddr_in peer_addr;
	CMainFrame* m_pMainFrame;
	CWinThread* m_pDataThread;
	friend unsigned int AFX_CDECL DataThread( LPVOID pvParams );
};

#endif // !defined(AFX_DATAGRAMSOCKET_H__F8E9E0F8_F92E_11D2_BAFE_0080C773B9A1__INCLUDED_)
